<CFSETTING ENABLECFOUTPUTONLY="YES">
<!---// set default attributes //--->
<CFPARAM NAME="Attributes.JS_WDDX" DEFAULT="/cfide/scripts/wddx.js">
<CFPARAM NAME="Attributes.JS_WDDXFORMWIZARD" DEFAULT="wddxFormWizard.js">
<CFPARAM NAME="Attributes.FORMNAME" DEFAULT="document.wddxFormWizard">
<CFPARAM NAME="Attributes.EXCLUDE" DEFAULT="">
<CFPARAM NAME="Attributes.WDDXFIELDNAME" DEFAULT="wddxPacket">
<CFPARAM NAME="Attributes.SHOWDEBUG" DEFAULT="NO">
<CFPARAM NAME="Attributes.SHOWNAVIGATION" DEFAULT="NO">
<CFPARAM NAME="Attributes.SHOWBUTTONS" DEFAULT="BACK,RESET,NEXT">
<CFPARAM NAME="Attributes.BTN_NEXT" DEFAULT="Next &gt;">
<CFPARAM NAME="Attributes.BTN_BACK" DEFAULT="&lt; Back">
<CFPARAM NAME="Attributes.BTN_RESET" DEFAULT="Reset">
<CFPARAM NAME="Attributes.BTN_FINISH" DEFAULT="Finish">
<CFPARAM NAME="Attributes.FINISH_URL" DEFAULT="">
<CFPARAM NAME="Attributes.SAVEONBACK" DEFAULT="YES">

<!---// set default variables //--->
<CFSCRIPT>
// formWizard configuration info
formWizard.Version = "1.1";

// check to see if the form should be saved when going back to a previous form
if( YesNoFormat(Attributes.SAVEONBACK) ){
	strGoBackFunction = "goBack();";      // save form
} else {
	strGoBackFunction = "goBack(false);"; // don't save form
}

stcVariables = StructNew();
stcVariables["BACK"] = "<INPUT TYPE=""Button"" VALUE=""#Attributes.BTN_BACK#"" onClick=""#strGoBackFunction#"">";
stcVariables["RESET"] = "<INPUT TYPE=""Reset"" VALUE=""#Attributes.BTN_RESET#"">";
stcVariables["NEXT"] = "<INPUT TYPE=""Button"" VALUE=""#Attributes.BTN_NEXT#"" onClick=""goForward();"">";
stcVariables["FINISH"] = "<INPUT TYPE=""Button"" VALUE=""#Attributes.BTN_FINISH#"" onClick=""goToURL('#Trim(Attributes.FINISH_URL)#');"">";
</CFSCRIPT>

<!---// if there is a WDDX packet passed through the form scope, use it //--->
<CFIF IsDefined("FORM.#Attributes.WDDXFIELDNAME#")>
	<CFSET SetVariable("Variables.wddxPacket", Evaluate("FORM.#Attributes.WDDXFIELDNAME#"))>
	<CFWDDX ACTION="WDDX2JS" INPUT="#Variables.wddxPacket#" TOPLEVELVARIABLE="wddxPacket" OUTPUT="objWDDX">
<!---// check to see if the user specified a WDDX packet to use //--->
<CFELSEIF IsDefined("Attributes.wddxPacket") AND (Left(LTrim(LCase(Attributes.wddxPacket)), 12) EQ "<wddxpacket ")>
	<CFWDDX ACTION="WDDX2JS" INPUT="#Attributes.wddxPacket#" TOPLEVELVARIABLE="wddxPacket" OUTPUT="objWDDX">
<!---// otherwise, use a new structure //--->
<CFELSE>
	<CFSET stcWizard = StructNew()>
	<CFSET stcWizard["totalforms"] = 0>
	<CFWDDX ACTION="CFML2JS" INPUT="#stcWizard#" TOPLEVELVARIABLE="wddxPacket" OUTPUT="objWDDX">
</CFIF>

<!---// insert JavaScript code in between the <HEAD></HEAD> tags //--->
<CFHTMLHEAD TEXT="
<!--// load the WDDX library //-->
<SCRIPT SRC=""#Attributes.JS_WDDX#""></SCRIPT>
<!--// load the Form Wizard library //-->
<SCRIPT SRC=""#Attributes.JS_WDDXFORMWIZARD#""></SCRIPT>
<SCRIPT>
<!--//
// create the global variables
var myForm, myField, myPacketName, myRecordset, lstExcludeFields, iFormPOS;

function initWDDX(){
	// create the pointer to the form object on the page
	myForm = #Attributes.FORMNAME#;
	// create the pointer to the hidden field on the page, that will be used for the WDDX packet
	myPacketName = ""#Attributes.WDDXFIELDNAME#"";
	// create the pointer to the WDDX recordset (this should be equal to the ""TopLevelVariable""
	// which is set in the CFWDDX tag
	myRecordset = wddxPacket;
	// specify a list of fields to ignore
	lstExcludeFields = ""#Attributes.EXCLUDE#"";

	// do not change the following statements
	myField = eval(""myForm."" + myPacketName);
	
	// check to see if the current form is in the WDDX packet
	iFormPOS = checkForForm();
	
	// populate the fields if any fields are found in the WDDX packet
	populateFields();
	
}

// the WDDX packet array
#objWDDX#

// append the initWDDX() function to the body's onLoad event
window.onload = initWDDX; 
/*
if( window.onload != null ){
	window.onload = eval(""window.onload();initWDDX""); 
} else {
	window.onload = initWDDX; 
}
*/
//-->
</SCRIPT>
">
<CFSETTING ENABLECFOUTPUTONLY="NO">
<INPUT TYPE="Hidden" NAME="<CFOUTPUT>#Attributes.WDDXFIELDNAME#</CFOUTPUT>" VALUE="">
<CFLOOP INDEX="button" LIST="#Attributes.SHOWBUTTONS#">
<CFOUTPUT>#stcVariables[button]#
</CFOUTPUT></CFLOOP>

<SCRIPT><!--//
<CFIF YesNoFormat(Attributes.SHOWDEBUG)>showDebug();</CFIF>
<CFIF YesNoFormat(Attributes.SHOWNAVIGATION)>showNavigation();</CFIF>
//--></SCRIPT>
